/*
 * Decompiled with CFR 0.152.
 */
package turing;

import java.util.Vector;
import turing.TMTape;
import turing.TMTransition;

public class TM {
    private Vector<String> lsRules;
    private int size;
    private int tapePos = 0;
    private TMTape tape = new TMTape();
    private TMTransition tm = new TMTransition();
    private String lastError = "";

    public TMTape getTape() {
        return this.tape;
    }

    public TMTransition getTransition() {
        return this.tm;
    }

    public int getTapePos() {
        return this.tapePos;
    }

    public String getLastError() {
        return this.lastError;
    }

    public int init(String inputString, Vector<String> ruleList) {
        this.lsRules = ruleList;
        this.size = this.lsRules.size();
        return this.setInitialState(inputString);
    }

    private int setInitialState(String initialCharacters) {
        this.tape.initTape(initialCharacters);
        String search = "A," + this.tape.getSymbol(0L) + ",";
        this.tapePos = 0;
        return this.findNextRule(search);
    }

    private int findNextRule(String strSearch) {
        int i = 0;
        while (i < this.size) {
            if (this.lsRules.get(i).startsWith(strSearch)) {
                this.tm.setFromString(this.lsRules.get(i));
                return 1;
            }
            ++i;
        }
        this.lastError = "" + strSearch.charAt(0) + strSearch.charAt(2);
        return -2;
    }

    public int nextRule() {
        char nc = this.tm.getNewChar();
        this.tape.setSymbol(this.tapePos, nc);
        this.tapePos += this.tm.getDirection();
        char ns = this.tm.getNewState();
        if (ns == 'S') {
            return -1;
        }
        String search = String.valueOf(ns) + "," + this.tape.getSymbol(this.tapePos) + ",";
        return this.findNextRule(search);
    }
}

