/*
 * Decompiled with CFR 0.152.
 */
package turing;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import turing.TM;
import turing.TapeCanvas;

public class TuringMaschineFrame
extends JFrame
implements Runnable {
    TM tm = new TM();
    String delta = "\u03b4";
    String blank = "\u25fb";
    TreeSet treeSymbol = new TreeSet();
    Vector lsText = new Vector();
    ImageIcon iconError;
    ImageIcon iconGood;
    ImageIcon iconGoLeft;
    ImageIcon iconGoRight;
    ImageIcon iconGoLeftDis;
    ImageIcon iconGoRightDis;
    String strImage = "res/tm.gif";
    Thread turingMaschineThread;
    int speed = 500;
    int tapeInitPos;
    int tapeOffsetPos;
    int oldPos = this.tapeOffsetPos = (this.tapeInitPos = 8);
    int tapeLen = 23;
    long steps = 0L;
    boolean runThread = false;
    boolean isFinished = false;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton jButtonToRight = null;
    Image img;
    private int errorCodeNumber = 0;
    StyledDocument document = new DefaultStyledDocument();
    TapeCanvas canvas;
    Graphics gg;
    Color hellblau = new Color(230, 255, 255);
    Color darkgreen = new Color(0, 100, 0);
    Color darkred = new Color(178, 34, 34);
    Color colorGold = new Color(255, 215, 0);
    Color colorNumber = new Color(230, 230, 230);
    Color grey = Color.LIGHT_GRAY;
    Color black = Color.BLACK;
    Color red = Color.RED;
    Color blue = new Color(0, 0, 205);
    private JButton jButtonToLeft = null;
    Font tmF;
    Font stdF;
    private JTextField jTextFieldTM = null;
    private JLabel jLabel = null;
    private JTextField jTextFieldSteps = null;
    private JLabel jLabelImage = null;
    private JTextArea jTextArea = null;
    private JTextPane jTextPane = null;
    private JButton jButtonStart = null;
    private JButton jButtonStop = null;
    private JButton jButtonStep = null;
    private JButton jButtonReset = null;
    private JSlider jSlider = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabelInfo = null;
    private JLabel jLabel1 = null;
    private JTextField jTextField = null;
    private JPanel jPanel = null;
    private JLabel jLabelInfo2 = null;
    private JScrollPane jScrollPane = null;
    private JScrollPane jScrollPane1 = null;
    private JButton jButtonGoLeft = null;
    private JButton jButtonGoRight = null;

    public TuringMaschineFrame() {
        super("Turing-Maschine (Swing)");
        this.setDefaultCloseOperation(2);
        this.setSize(660, 600);
        this.setLocationByPlatform(true);
        this.setContentPane(this.getJContentPane());
        this.getJContentPane().add((Component)this.getPaintArea(), null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                TuringMaschineFrame.this.gg = TuringMaschineFrame.this.canvas.getGraphics();
                TuringMaschineFrame.this.stdF = TuringMaschineFrame.this.getFont();
                TuringMaschineFrame.this.tmF = new Font("TimesRoman", 1, 21);
                if (TuringMaschineFrame.this.gg != null) {
                    TuringMaschineFrame.this.gg.setFont(TuringMaschineFrame.this.tmF);
                    TuringMaschineFrame.this.canvas.setVisible(true);
                }
                TuringMaschineFrame.this.iconError = TuringMaschineFrame.this.loadIcon("error.png");
                TuringMaschineFrame.this.iconGood = TuringMaschineFrame.this.loadIcon("good.png");
                TuringMaschineFrame.this.iconGoLeft = TuringMaschineFrame.this.loadIcon("left_go.gif");
                TuringMaschineFrame.this.iconGoRight = TuringMaschineFrame.this.loadIcon("right_go.gif");
                TuringMaschineFrame.this.iconGoLeftDis = TuringMaschineFrame.this.loadIcon("left_go_dis.gif");
                TuringMaschineFrame.this.iconGoRightDis = TuringMaschineFrame.this.loadIcon("right_go_dis.gif");
                TuringMaschineFrame.this.strImage = "tm.gif";
                TuringMaschineFrame.this.img = TuringMaschineFrame.this.loadImage(TuringMaschineFrame.this.strImage);
                TuringMaschineFrame.this.onButtonLeft();
                TuringMaschineFrame.this.jLabelInfo.setText("Dr\u00fccke auf \u00bbStart\u00ab - das Programm macht Dir dann ein X f\u00fcr ein U vor.");
                TuringMaschineFrame.this.showGoButtons(false);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                TuringMaschineFrame.this.stopThread();
            }
        });
    }

    private ImageIcon loadIcon(String name) {
        URL url = this.getClass().getResource("res/" + name);
        if (url == null) {
            System.err.println("WARN: Icon not found: " + name);
            return new ImageIcon();
        }
        return new ImageIcon(url);
    }

    private Image loadImage(String name) {
        URL url = this.getClass().getResource("res/" + name);
        if (url == null) {
            System.err.println("WARN: Image not found: " + name);
            return null;
        }
        return new ImageIcon(url).getImage();
    }

    private int countLetter(String text, char letter) {
        int counter = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == letter) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    private void showGoButtons(boolean show) {
        this.jButtonGoLeft.setEnabled(show);
        this.jButtonGoRight.setEnabled(show);
        if (show) {
            if (this.iconGoLeft != null) {
                this.jButtonGoLeft.setIcon(this.iconGoLeft);
            }
            if (this.iconGoRight != null) {
                this.jButtonGoRight.setIcon(this.iconGoRight);
            }
        } else {
            if (this.iconGoLeftDis != null) {
                this.jButtonGoLeft.setIcon(this.iconGoLeftDis);
            }
            if (this.iconGoRightDis != null) {
                this.jButtonGoRight.setIcon(this.iconGoRightDis);
            }
        }
    }

    private void onInfo(String text, String body, boolean warning) {
        if (warning) {
            if (this.iconError != null) {
                this.jLabelImage.setIcon(this.iconError);
            }
            this.jLabelInfo.setForeground(this.darkred);
            this.jLabelInfo2.setForeground(this.darkred);
            this.jLabelInfo.setText(text);
            this.jLabelInfo2.setText(body);
        } else {
            if (this.iconGood != null) {
                this.jLabelImage.setIcon(this.iconGood);
            }
            this.jLabelInfo.setForeground(this.darkgreen);
            this.jLabelInfo2.setForeground(this.darkgreen);
            this.jLabelInfo.setText(text);
            this.jLabelInfo2.setText(body);
        }
    }

    private void translate(int lineNum, String state1, String letter1, String state2, String letter2, String move) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        try {
            attributes.addAttribute(StyleConstants.CharacterConstants.Background, this.colorNumber);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.black);
            this.document.insertString(0, String.valueOf(this.getLineNumber(lineNum)) + " ", attributes);
            attributes = new SimpleAttributeSet();
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.grey);
            attributes.addAttribute(StyleConstants.CharacterConstants.Background, Color.WHITE);
            this.document.insertString(5, " " + this.delta + "(", attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.black);
            this.document.insertString(8, state1, attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.black);
            this.document.insertString(9, ",", attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.black);
            this.document.insertString(10, letter1, attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.grey);
            this.document.insertString(11, ") =  (", attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.black);
            this.document.insertString(17, state2, attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.black);
            this.document.insertString(18, ",", attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.black);
            this.document.insertString(19, letter2, attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.black);
            this.document.insertString(20, ",", attributes);
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
            Color moveColor = this.red;
            if (move.equals("L")) {
                moveColor = this.darkgreen;
            }
            if (move.equals("R")) {
                moveColor = this.blue;
            }
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, moveColor);
            this.document.insertString(21, move, attributes);
            attributes = new SimpleAttributeSet();
            attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
            attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, this.grey);
            this.document.insertString(22, ")\n", attributes);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Bad insert");
        }
    }

    private String getLineNumber(int lineNum) {
        if (lineNum > 1000) {
            return String.valueOf(lineNum);
        }
        if (lineNum > 99) {
            return " " + lineNum;
        }
        if (lineNum > 9) {
            return " 0" + lineNum;
        }
        return " 00" + lineNum;
    }

    private int isValid(Vector lsText) {
        int size = lsText.size();
        if (size == 0) {
            return 0;
        }
        int countA = 0;
        int countS = 0;
        int i = 0;
        while (i < size) {
            String line = (String)lsText.get(i);
            if (line.length() != 9) {
                return i + 1;
            }
            if (this.countLetter(line, ',') != 4) {
                return i + 1;
            }
            if (line.charAt(1) != ',' || line.charAt(3) != ',' || line.charAt(5) != ',' || line.charAt(7) != ',') {
                return i + 1;
            }
            String ende = line.substring(8);
            if (!(ende.equals("L") || ende.equals("N") || ende.equals("R"))) {
                this.errorCodeNumber = i + 1;
                return 66;
            }
            int a = line.indexOf(65);
            if (a != -1 && a == 0) {
                ++countA;
            }
            int p = line.indexOf(83);
            if (this.countLetter(line, 'S') > 1) {
                return i + 1;
            }
            if (p != -1 && p != 4) {
                return i + 1;
            }
            if (p == 4) {
                ++countS;
            }
            int b = line.indexOf(95);
            if (this.countLetter(line, '_') > 2) {
                return i + 1;
            }
            if (b != -1 && b != 2 && b != 6) {
                return i + 1;
            }
            ++i;
        }
        if (countA == 0) {
            return 8888;
        }
        if (countS == 0) {
            return 9999;
        }
        return -1;
    }

    private Vector textAreaToVectorList() {
        Vector<String> res = new Vector<String>();
        int lines = this.jTextArea.getLineCount();
        String text = this.jTextArea.getText();
        int i = 0;
        while (i < lines) {
            try {
                int start = this.jTextArea.getLineStartOffset(i);
                int end = this.jTextArea.getLineEndOffset(i);
                String t = text.substring(start, end);
                t = t.trim();
                t = t.replaceAll("\\s", "");
                t = t.replaceAll("_", this.blank);
                if (!t.isEmpty()) {
                    res.add(t);
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            ++i;
        }
        return res;
    }

    private Canvas getPaintArea() {
        Color bg = Color.white;
        int leftX = 0;
        int rightX = 660;
        int leftY = 70;
        int rightY = 90;
        this.canvas = new TapeCanvas();
        this.canvas.setBackground(bg);
        this.canvas.setBounds(new Rectangle(leftX, leftY, rightX, rightY));
        return this.canvas;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelInfo2 = new JLabel();
            this.jLabelInfo2.setBounds(new Rectangle(48, 51, 599, 15));
            this.jLabelInfo2.setFont(new Font("Dialog", 0, 12));
            this.jLabelInfo2.setText("");
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(10, 7, 113, 18));
            this.jLabel1.setText("Eingabewort:");
            this.jLabelInfo = new JLabel();
            this.jLabelInfo.setBounds(new Rectangle(48, 32, 599, 15));
            this.jLabelInfo.setText("  ");
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(new Rectangle(437, 211, 102, 15));
            this.jLabel4.setText("Eingabefeld");
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(new Rectangle(63, 211, 166, 15));
            this.jLabel3.setText("\u00dcbergangsfunktion");
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(268, 506, 128, 15));
            this.jLabel2.setText("Geschwindigkeit");
            this.jLabelImage = new JLabel();
            this.jLabelImage.setBounds(new Rectangle(12, 32, 33, 35));
            this.jLabelImage.setText(" ");
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(258, 477, 63, 15));
            this.jLabel.setText("Schritte:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.setBackground(Color.white);
            this.jContentPane.add((Component)this.getJButtonToRight(), null);
            this.jContentPane.add((Component)this.getJButtonToLeft(), null);
            this.jContentPane.add((Component)this.getJTextFieldTM(), null);
            this.jContentPane.add((Component)this.jLabel, null);
            this.jContentPane.add((Component)this.getJTextFieldSteps(), null);
            this.jContentPane.add((Component)this.jLabelImage, null);
            this.jContentPane.add((Component)this.getJButtonStart(), null);
            this.jContentPane.add((Component)this.getJButtonStop(), null);
            this.jContentPane.add((Component)this.getJButtonStep(), null);
            this.jContentPane.add((Component)this.getJButtonReset(), null);
            this.jContentPane.add((Component)this.getJSlider(), null);
            this.jContentPane.add((Component)this.jLabel2, null);
            this.jContentPane.add((Component)this.jLabel3, null);
            this.jContentPane.add((Component)this.jLabel4, null);
            this.jContentPane.add((Component)this.jLabelInfo, null);
            this.jContentPane.add((Component)this.getJPanel(), null);
            this.jContentPane.add((Component)this.jLabelInfo2, null);
            this.jContentPane.add((Component)this.getJScrollPane(), null);
            this.jContentPane.add((Component)this.getJScrollPane1(), null);
            this.jContentPane.add((Component)this.getJButtonGoLeft(), null);
            this.jContentPane.add((Component)this.getJButtonGoRight(), null);
        }
        return this.jContentPane;
    }

    private JButton getJButtonToRight() {
        if (this.jButtonToRight == null) {
            this.jButtonToRight = new JButton();
            this.jButtonToRight.setBounds(new Rectangle(256, 290, 141, 28));
            this.jButtonToRight.setText("\u25b6");
            this.jButtonToRight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TuringMaschineFrame.this.jTextArea.setText("");
                    int i = 0;
                    while (i < TuringMaschineFrame.this.lsText.size()) {
                        String t = (String)TuringMaschineFrame.this.lsText.get(i);
                        t = t.replaceAll(TuringMaschineFrame.this.blank, "_");
                        TuringMaschineFrame.this.jTextArea.append(String.valueOf(t) + "\n");
                        ++i;
                    }
                }
            });
        }
        return this.jButtonToRight;
    }

    private void putLetter(int pos, String letter) {
        if (this.gg == null) {
            return;
        }
        this.gg.setColor(Color.black);
        if (letter.equals(this.blank)) {
            letter = "";
        }
        this.gg.setFont(this.stdF);
        int scale = 28;
        if (pos > 6) {
            scale = 27;
        }
        this.gg.drawString(letter, (pos + 1) * scale, 68);
    }

    private void undraw(int pos) {
        if (this.gg == null) {
            return;
        }
        this.gg.setColor(Color.WHITE);
        this.gg.fillRoundRect(pos, 0, 50, 49, 8, 8);
    }

    private void redrawAll() {
        if (this.gg == null) {
            return;
        }
        this.gg.setColor(Color.white);
        int leftX = 0;
        int rightX = 660;
        int leftY = 0;
        int rightY = 90;
        this.gg.fillRect(leftX, leftY, rightX, rightY);
        this.drawTape();
    }

    private void drawTape() {
        if (this.gg == null) {
            return;
        }
        this.gg.setColor(Color.BLACK);
        this.gg.drawLine(2, 50, 658, 50);
        this.gg.drawLine(2, 77, 658, 77);
        int x = 20;
        while (x < 658) {
            this.gg.drawLine(x, 50, x, 77);
            x += 27;
        }
    }

    public void startThread() {
        if (this.turingMaschineThread == null) {
            this.turingMaschineThread = new Thread((Runnable)this, "TM");
            this.turingMaschineThread.start();
        }
    }

    public void stopThread() {
        this.runThread = false;
        this.stop();
    }

    public void stop() {
        if (this.turingMaschineThread != null) {
            this.turingMaschineThread.stop();
            this.turingMaschineThread = null;
        }
    }

    @Override
    public void run() {
        while (this.runThread) {
            this.onStep();
            try {
                Thread.sleep(this.speed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private JButton getJButtonToLeft() {
        if (this.jButtonToLeft == null) {
            this.jButtonToLeft = new JButton();
            this.jButtonToLeft.setBounds(new Rectangle(256, 260, 141, 28));
            this.jButtonToLeft.setText("\u25c0");
            this.jButtonToLeft.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TuringMaschineFrame.this.onButtonLeft();
                }
            });
        }
        return this.jButtonToLeft;
    }

    private void onButtonLeft() {
        Vector tmp_lsText = this.textAreaToVectorList();
        int valid = this.isValid(tmp_lsText);
        this.jLabelInfo.setText("");
        if (valid != -1) {
            if (valid == 0) {
                this.onInfo("Fehler!", "Es sind keine Eingabedaten f\u00fcr die Turingmaschine vorhanden!", true);
            }
            if (valid == 8888) {
                this.onInfo("Fehler - kein Startzustand vorhanden!", "Jede Turingmaschine muss einen Startzustand (hier 'A') haben!", true);
            }
            if (valid == 9999) {
                this.onInfo("Fehler - kein Endzustand vorhanden!", "Jede Turingmaschine muss Endzust\u00e4nde (hier '{S}') besitzen!", true);
            }
            if (valid == 66) {
                this.onInfo("Aktionsfehler des Schreib-Lese-Kopfes in Zeile: " + this.errorCodeNumber, "Der Schreib-Lese-Kopf kann sich nur nach R f\u00fcr rechts, L f\u00fcr links und N f\u00fcr neutral bewegen! ", true);
            }
            if (valid != 0 && valid != 8888 && valid != 9999 && valid != 66) {
                this.onInfo("Eingabefehler!", "Eingabefehler (Syntaxfehler) in Zeile " + valid + "!", true);
            }
            return;
        }
        this.lsText = this.textAreaToVectorList();
        this.jTextPane.setText("");
        int size = this.lsText.size();
        int i = size - 1;
        while (i >= 0) {
            String t = (String)this.lsText.get(i);
            this.translate(i + 1, t.substring(0, 1), t.substring(2, 3), t.substring(4, 5), t.substring(6, 7), t.substring(8, 9));
            --i;
        }
        this.tmInfo();
        this.onReset();
    }

    private void tmInfo() {
        TreeSet<String> treeState = new TreeSet<String>();
        this.treeSymbol.clear();
        int size = this.lsText.size();
        int i = size - 1;
        while (i >= 0) {
            String state = ((String)this.lsText.get(i)).substring(0, 1);
            treeState.add(state);
            String symbol = ((String)this.lsText.get(i)).substring(2, 3);
            if (symbol.indexOf(95) < 0 && symbol.indexOf(this.blank) < 0) {
                this.treeSymbol.add(symbol);
            }
            if ((symbol = ((String)this.lsText.get(i)).substring(6, 7)).indexOf(95) < 0 && symbol.indexOf(this.blank) < 0) {
                this.treeSymbol.add(symbol);
            }
            --i;
        }
        Iterator it = treeState.iterator();
        String Z = "{";
        if (it.hasNext()) {
            Z = String.valueOf(Z) + (String)it.next();
        }
        while (it.hasNext()) {
            Z = String.valueOf(Z) + "," + (String)it.next();
        }
        Z = String.valueOf(Z) + ",S}";
        Iterator its = this.treeSymbol.iterator();
        String Sigma = "{";
        if (its.hasNext()) {
            Sigma = String.valueOf(Sigma) + (String)its.next();
        }
        while (its.hasNext()) {
            Sigma = String.valueOf(Sigma) + "," + (String)its.next();
        }
        String Gamma = String.valueOf(Sigma) + "," + this.blank + "}";
        Sigma = String.valueOf(Sigma) + "}";
        String M = "TM = (" + Z + "," + Sigma + "," + Gamma + "," + this.delta + ",A," + this.blank + ",{S})";
        this.jTextFieldTM.setText(M);
    }

    private void drawTM(int oldPos, int newPos, String letter) {
        if (this.gg == null) {
            return;
        }
        this.gg.setColor(Color.white);
        int x = oldPos * 27 + 20 + 1;
        int y = 51;
        int w = 26;
        int h = 26;
        this.gg.fillRect(x, y, w, h);
        int undrawPos = oldPos * 25 + 19 + oldPos;
        if (oldPos > 13) {
            undrawPos += oldPos;
        }
        this.undraw(undrawPos);
        int imgPos = newPos * 25 + 19 + newPos;
        if (newPos > 13) {
            imgPos += newPos;
        }
        this.gg.drawImage(this.img, imgPos, 0, this.canvas);
        this.gg.setColor(this.blue);
        this.gg.setFont(this.tmF);
        this.gg.drawString(letter, imgPos + 12, 34);
        this.gg.setColor(this.hellblau);
        x = newPos * 27 + 20 + 1;
        y = 51;
        w = 26;
        h = 26;
        this.gg.fillRect(x, y, w, h);
    }

    private JTextField getJTextFieldTM() {
        if (this.jTextFieldTM == null) {
            this.jTextFieldTM = new JTextField();
            this.jTextFieldTM.setBounds(new Rectangle(11, 8, 644, 19));
        }
        return this.jTextFieldTM;
    }

    private JTextField getJTextFieldSteps() {
        if (this.jTextFieldSteps == null) {
            this.jTextFieldSteps = new JTextField();
            this.jTextFieldSteps.setBounds(new Rectangle(324, 474, 74, 19));
        }
        return this.jTextFieldSteps;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setBackground(new Color(254, 255, 255));
            this.jTextArea.setText("A,u,A,x,R\nA,_,S,_,L");
        }
        return this.jTextArea;
    }

    private JTextPane getJTextPane() {
        if (this.jTextPane == null) {
            this.jTextPane = new JTextPane(this.document);
        }
        return this.jTextPane;
    }

    private JButton getJButtonStart() {
        if (this.jButtonStart == null) {
            this.jButtonStart = new JButton();
            this.jButtonStart.setBounds(new Rectangle(257, 347, 141, 28));
            this.jButtonStart.setText("Start");
            this.jButtonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!TuringMaschineFrame.this.onReset()) {
                        return;
                    }
                    TuringMaschineFrame.this.runThread = true;
                    TuringMaschineFrame.this.startThread();
                }
            });
        }
        return this.jButtonStart;
    }

    private void inputToTape() {
        String input = this.jTextField.getText().trim();
        int i = 0;
        while (i < input.length()) {
            this.putLetter(i + this.tapeOffsetPos, "" + input.charAt(i));
            ++i;
        }
    }

    private boolean canStart() {
        if (this.isValid(this.lsText) != -1) {
            return false;
        }
        String input = this.jTextField.getText().trim();
        if (input.indexOf(95) >= 0 || input.indexOf(32) >= 0) {
            this.onInfo("Eingabefehler!", "Das Blanksymbol (hier das Zeichen '_' - Leerzeichen) ist nicht Teil des Eingabealphabets!", true);
            return false;
        }
        int i = 0;
        while (i < input.length()) {
            String s = "" + input.charAt(i);
            if (!this.treeSymbol.contains(s)) {
                this.onInfo("Eingabefehler!", "Das Eingabewort darf nur Zeichen aus dem Eingabealphabet enthalten.", true);
                return false;
            }
            ++i;
        }
        return true;
    }

    private JButton getJButtonStop() {
        if (this.jButtonStop == null) {
            this.jButtonStop = new JButton();
            this.jButtonStop.setBounds(new Rectangle(257, 377, 141, 28));
            this.jButtonStop.setText("Stop");
            this.jButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TuringMaschineFrame.this.stopThread();
                }
            });
        }
        return this.jButtonStop;
    }

    private void colorLine(int lineNumber, Color color) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        attributes.addAttribute(StyleConstants.CharacterConstants.Background, color);
        this.document.setCharacterAttributes(lineNumber * 24, 5, attributes, false);
    }

    private JButton getJButtonStep() {
        if (this.jButtonStep == null) {
            this.jButtonStep = new JButton();
            this.jButtonStep.setBounds(new Rectangle(257, 406, 141, 28));
            this.jButtonStep.setSelected(true);
            this.jButtonStep.setToolTipText("Das Programm schrittweise ausf\u00fchren");
            this.jButtonStep.setText("Schrittweise");
            this.jButtonStep.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TuringMaschineFrame.this.onStep();
                }
            });
        }
        return this.jButtonStep;
    }

    private boolean onReset() {
        this.showGoButtons(false);
        this.stopThread();
        if (!this.canStart()) {
            return false;
        }
        this.isFinished = false;
        this.redrawAll();
        this.steps = 0L;
        this.tapeOffsetPos = this.tapeInitPos;
        this.oldPos = this.tapeInitPos;
        this.jTextFieldSteps.setText("0");
        this.drawTM(this.oldPos, this.tapeOffsetPos, "A");
        this.inputToTape();
        String input = this.jTextField.getText().trim();
        this.tm.init(input, this.lsText);
        this.jLabelInfo.setText("");
        this.jLabelInfo2.setText("");
        this.jLabelImage.setIcon(null);
        int i = 0;
        while (i < this.lsText.size()) {
            this.colorLine(i, this.colorNumber);
            ++i;
        }
        return true;
    }

    private JButton getJButtonReset() {
        if (this.jButtonReset == null) {
            this.jButtonReset = new JButton();
            this.jButtonReset.setBounds(new Rectangle(257, 435, 141, 28));
            this.jButtonReset.setText("Zur\u00fccksetzen");
            this.jButtonReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TuringMaschineFrame.this.onReset();
                }
            });
        }
        return this.jButtonReset;
    }

    private JSlider getJSlider() {
        if (this.jSlider == null) {
            this.jSlider = new JSlider();
            this.jSlider.setBounds(new Rectangle(265, 526, 130, 16));
            this.jSlider.setMaximum(100);
            this.jSlider.setMinimum(4);
            this.jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TuringMaschineFrame.this.speed = 2005 - 20 * TuringMaschineFrame.this.jSlider.getValue();
                }
            });
        }
        return this.jSlider;
    }

    private void lineAction(String oldRule, String newRule) {
        int oldLine = this.lsText.indexOf(oldRule);
        this.colorLine(oldLine, this.colorNumber);
        int newLine = this.lsText.indexOf(newRule);
        this.colorLine(newLine, this.colorGold);
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setBounds(new Rectangle(144, 6, 137, 19));
            this.jTextField.setToolTipText("Das Eingabewort kann alle Zeichen des Eingabealphabet beinhalten!");
            this.jTextField.setText("uuu");
        }
        return this.jTextField;
    }

    private void remapTape() {
        if (this.oldPos >= 22) {
            this.tapeOffsetPos -= 13;
            this.oldPos = this.tm.getTapePos() + this.tapeOffsetPos;
            this.redrawTape();
        } else if (this.oldPos <= 0) {
            this.tapeOffsetPos += 13;
            this.oldPos = this.tm.getTapePos() + this.tapeOffsetPos;
            this.redrawTape();
        }
    }

    private void redrawTape() {
        this.redrawAll();
        int i = 0;
        while (i < this.tapeLen) {
            int pos = i - this.tapeOffsetPos;
            String s = "" + this.tm.getTape().getSymbol(pos);
            this.putLetter(i, s);
            ++i;
        }
    }

    private void onStep() {
        int tapePos;
        if (this.isFinished) {
            return;
        }
        this.jTextFieldSteps.setText("" + ++this.steps);
        this.oldPos = this.tm.getTapePos() + this.tapeOffsetPos;
        this.remapTape();
        String newChar = "" + this.tm.getTransition().getNewChar();
        String oldRule = this.tm.getTransition().getAsString();
        int res = this.tm.nextRule();
        if (res > 0) {
            String newRule = this.tm.getTransition().getAsString();
            this.lineAction(oldRule, newRule);
            tapePos = this.tm.getTapePos() + this.tapeOffsetPos;
            String oldChar = "" + this.tm.getTransition().getCurrentChar();
            String oldState = "" + this.tm.getTransition().getCurrentState();
            this.drawTM(this.oldPos, tapePos, oldState);
            this.putLetter(this.oldPos, newChar);
            this.putLetter(tapePos, oldChar);
        }
        if (res == -1) {
            this.showGoButtons(true);
            this.isFinished = true;
            tapePos = this.tm.getTapePos() + this.tapeOffsetPos;
            String newState = "" + this.tm.getTransition().getNewState();
            String newRule = this.tm.getTransition().getAsString();
            this.lineAction(oldRule, newRule);
            this.drawTM(this.oldPos, tapePos, newState);
            this.putLetter(tapePos, "" + this.tm.getTape().getSymbol(this.tm.getTapePos()));
            this.putLetter(tapePos - 1, "" + this.tm.getTape().getSymbol(this.tm.getTapePos() - 1));
            this.putLetter(tapePos + 1, "" + this.tm.getTape().getSymbol(this.tm.getTapePos() + 1));
            this.onInfo("Maschine hat gestoppt!", "Der Endzustand 'S' wurde erreicht.", false);
            this.stopThread();
        }
        if (res == -2) {
            String state = " '" + this.tm.getLastError().charAt(0) + "' ";
            String symbol = " '" + this.tm.getLastError().charAt(1) + "' ";
            this.onInfo("Programmabbruch!", "Keine Regel f\u00fcr Zustand" + state + " und Zeichen" + symbol + "vorhanden!", true);
            this.stopThread();
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.setBounds(new Rectangle(352, 171, 293, 30));
            this.jPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.jPanel.setBackground(Color.white);
            this.jPanel.add((Component)this.getJTextField(), null);
            this.jPanel.add((Component)this.jLabel1, null);
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(new Rectangle(60, 238, 168, 298));
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setViewportView(this.getJTextPane());
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setBounds(new Rectangle(436, 238, 103, 298));
            this.jScrollPane1.setHorizontalScrollBarPolicy(31);
            this.jScrollPane1.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane1;
    }

    private JButton getJButtonGoLeft() {
        if (this.jButtonGoLeft == null) {
            this.jButtonGoLeft = new JButton();
            this.jButtonGoLeft.setBounds(new Rectangle(2, 121, 18, 26));
            this.jButtonGoLeft.setFont(new Font("Dialog", 0, 10));
            this.jButtonGoLeft.setHorizontalTextPosition(2);
            this.jButtonGoLeft.setBackground(Color.white);
            this.jButtonGoLeft.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    --TuringMaschineFrame.this.tapeOffsetPos;
                    TuringMaschineFrame.this.oldPos = TuringMaschineFrame.this.tm.getTapePos() + TuringMaschineFrame.this.tapeOffsetPos;
                    TuringMaschineFrame.this.redrawTape();
                }
            });
        }
        return this.jButtonGoLeft;
    }

    private JButton getJButtonGoRight() {
        if (this.jButtonGoRight == null) {
            this.jButtonGoRight = new JButton();
            this.jButtonGoRight.setBounds(new Rectangle(642, 121, 18, 26));
            this.jButtonGoRight.setBackground(Color.white);
            this.jButtonGoRight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ++TuringMaschineFrame.this.tapeOffsetPos;
                    TuringMaschineFrame.this.oldPos = TuringMaschineFrame.this.tm.getTapePos() + TuringMaschineFrame.this.tapeOffsetPos;
                    TuringMaschineFrame.this.redrawTape();
                }
            });
        }
        return this.jButtonGoRight;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TuringMaschineFrame f = new TuringMaschineFrame();
                f.setVisible(true);
            }
        });
    }
}

